#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Greek VariantsMod01.fsh  by Dr2   
//https://www.shadertoy.com/view/ftVGDy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.5 //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// "Greek Variants" by dr2 - 2021
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License

/*
 Beware of viruses bearing Greek letters (especially the Omicron).
 
 Using the Greek characters included in otaviogood's "SDF Texture Font"; not
 following WHO naming guidelines.

  No. 14 in "Font" series
    "Font3d"               (ltsyRr)
    "Lorem Ipsum"          (XlXyR8)
    "Historical Text"      (4tXcRH)
    "Font Clock"           (MlscR8)
    "Alphaville"           (XtfczN)
    "Pi in the Sky"        (4lfyR7)
    "Train Builder"        (4tlcz7)
    "Twisted Time"         (XlsyWH)
    "Alphawall"            (MlXyWf)
    "Alphapolis"           (4scyDj)
    "Pi Night"             (WsXyR4)
    "Corona Time"          (wsfcRX)
    "Facebook Time"        (sscXRj)
*/

#define AA  1  // (= 0/1) optional antialiasing

#if 0
#define VAR_ZERO min (iFrame, 0)
#else
#define VAR_ZERO 0
#endif

float PrBox2Df (vec2 p, vec2 b);
float Minv3 (vec3 p);
float SmoothMax (float a, float b, float r);
vec2 Rot2D (vec2 q, float a);
vec2 Rot2Cs (vec2 q, vec2 cs);
mat3 StdVuMat (float el, float az);
float FontTexDf (vec2 p, float id);
float Hashfv2 (vec2 p);
float Hashfv3 (vec3 p);
vec3 Hashv3f (float p);

vec3 cId, ltDir, obRot;
vec2 obRotCs[3], fntSize, qnTex;
float dstFar, tCur, gSize, vSpd, idTxt, qyHit;
bool cOcc;
const float pi = 3.1415927;
  
float ObjDf (vec3 p)
{
  float d;
  d = dstFar;
  if (cOcc) {
    p -= gSize * (cId + 0.5);
    p.yz = Rot2Cs (p.yz, obRotCs[0]);
    p.xz = Rot2Cs (p.xz, obRotCs[1]);
    p.xy = Rot2Cs (p.xy, obRotCs[2]);
    p.xz /= fntSize.x;
    d = 0.5 * SmoothMax (max (fntSize.x * FontTexDf (p.xz + 0.5, idTxt),
      PrBox2Df (p.xz, vec2 (0.35))), abs (p.y) - fntSize.y, 0.001);
    qyHit = p.y;
  }
  return d;
}

void ObjState ()
{
  vec3 vRan;
  float rNum;
  int c;
  vRan = Hashv3f (dot (cId, vec3 (31.1, 41.1, 51.1)) + 99.);
  cOcc = (vRan.x * step (1.5, length (cId.xz)) > 0.2);
  if (cOcc) {
    obRot = (vRan - 0.5) * (tCur + 10.);
    obRotCs[0] = sin (obRot.x + vec2 (0.5 * pi, 0.));
    obRotCs[1] = sin (obRot.y + vec2 (0.5 * pi, 0.));
    obRotCs[2] = sin (obRot.z + vec2 (0.5 * pi, 0.));
    rNum = Hashfv3 (vec3 (31.1, 41.1, 51.1) * cId + 99.);
    c = int (rNum * 20.3);
    if (c < 16) c += 0x80;
    else c = (c < 20) ? 0x6f : 0x1d;
    idTxt = float (c);
  }
}

vec3 ObjCell (vec3 p)
{
  cId.xz = floor (p.xz / gSize);
  p.y += vSpd * (tCur + 10.) * (1. + Hashfv2 (cId.xz));
  cId.y = floor (p.y / gSize);
  return p;
}

float ObjRay (vec3 ro, vec3 rd)
{
  vec3 p, cIdP, rdi;
  float dHit, d, eps;
  eps = 0.001;
  if (rd.x == 0.) rd.x = 0.001;
  if (rd.y == 0.) rd.y = 0.001;
  if (rd.z == 0.) rd.z = 0.001;
  rdi = 1. / rd;
  cIdP = vec3 (-999.);
  dHit = eps;
  for (int j = VAR_ZERO; j < 160; j ++) {
    p = ObjCell (ro + dHit * rd);
    if (cId != cIdP) {
      ObjState ();
      cIdP = cId;
    }
    d = ObjDf (p);
    d = min (d, abs (Minv3 ((gSize * (cId + step (0., rd)) - p) * rdi)) + eps);
    dHit += d;
    if (d < eps || dHit > dstFar) break;
  }
  if (d >= eps) dHit = dstFar;
  return dHit;
}

vec3 BgCol (vec3 rd)
{
  float t, gd, b;
  t = tCur * 1.5;
  b = dot (vec2 (atan (rd.x, rd.z), 0.5 * pi - acos (rd.y)), vec2 (2., sin (rd.x)));
  gd = clamp (sin (5. * b + t), 0., 1.) * clamp (sin (3.5 * b - t), 0., 1.) +
     clamp (sin (21. * b - t), 0., 1.) * clamp (sin (17. * b + t), 0., 1.);
  return mix (vec3 (0.35, 0.5, 1.), vec3 (0.1, 0.4, 0.3), 0.5 * (1. - rd.y)) *
     (0.24 + 0.44 * (rd.y + 1.) * (rd.y + 1.)) * (1. + 0.15 * gd);
}

vec3 ShowScene (vec3 ro, vec3 rd)
{
  vec3 col, bgCol, vn;
  float dstObj, s;
  gSize = 1.;
  fntSize = vec2 (0.45, 0.02);
  vSpd = 0.1;
  bgCol = BgCol (rd);
  col = bgCol;
  dstObj = ObjRay (ro, rd);
  if (dstObj < dstFar) {
    col = (idTxt == float (0x6f)) ? vec3 (0.9, 0.3, 0.3) : vec3 (0.8, 0.9, 0.5);
    s = step (abs (qyHit), fntSize.y - 0.001);
    col *= 1. - 0.6 * s;
    vn = (s > 0.) ? normalize (vec3 (qnTex,
       0.001 * sign (qyHit))).xzy : vec3 (0., sign (qyHit), 0.);
    vn.xy = Rot2D (vn.xy, - obRot.z);
    vn.xz = Rot2D (vn.xz, - obRot.y);
    vn.yz = Rot2D (vn.yz, - obRot.x);
    col *= 0.3 + 0.7 * max (dot (vn, ltDir), 0.);
    col = mix (col, bgCol, smoothstep (0.5, 0.95, dstObj / dstFar));
  }
  return clamp (col, 0., 1.);
}

#define txFnt texture0

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  mat3 vuMat;
  vec4 mPtr;
  vec3 ro, rd, col;
  vec2 canvas, uv;
  float el, az, sr, zmFac;
  canvas = iResolution.xy;
  uv = 2. * fragCoord.xy / canvas - 1.;
  uv.x *= canvas.x / canvas.y;
  tCur = iTime;
  mPtr = iMouse;
  mPtr.xy = mPtr.xy / canvas - 0.5;
  az = 0.25 * pi;
  el = 0.05 * pi;
  if (mPtr.z > 0.) {
    az += 2. * pi * mPtr.x;
    el += 0.7 * pi * mPtr.y;
  } else {
    az += pi * sin (0.003 * pi * tCur);
    el += 0.2 * pi * sin (0.002 * pi * tCur);
  }
  el = clamp (el, -0.3 * pi, 0.3 * pi);
  vuMat = StdVuMat (el, az);
  ro = vec3 (0.4);
  zmFac = 3.;
  dstFar = 20.;
  ltDir = vuMat * normalize (vec3 (1., 1., -2.));
#if ! AA
  const float naa = 1.;
#else
  const float naa = 3.;
#endif  
  col = vec3 (0.);
  sr = 2. * mod (dot (mod (floor (0.5 * (uv + 1.) * canvas), 2.), vec2 (1.)), 2.) - 1.;
  for (float a = float (VAR_ZERO); a < naa; a ++) {
    rd = vuMat * normalize (vec3 (uv + step (1.5, naa) * Rot2D (vec2 (0.5 / canvas.y, 0.),
       sr * (0.667 * a + 0.5) * pi), zmFac));
    col += (1. / naa) * ShowScene (ro, rd);
  }
#if 0   // (show full font texture instead)
  col = (max (abs (uv.x), abs (uv.y)) < 1.) ? texture2D (txFnt, 0.5 * (uv + 1.)).rgb : vec3 (0.);
#endif
  fragColor = vec4 (col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

float PrBox2Df (vec2 p, vec2 b)
{
  vec2 d;
  d = abs (p) - b;
  return min (max (d.x, d.y), 0.) + length (max (d, 0.));
}

float Minv3 (vec3 p)
{
  return min (p.x, min (p.y, p.z));
}

float SmoothMin (float a, float b, float r)
{
  float h;
  h = clamp (0.5 + 0.5 * (b - a) / r, 0., 1.);
  return mix (b - h * r, a, h);
}

float SmoothMax (float a, float b, float r)
{
  return - SmoothMin (- a, - b, r);
}

mat3 StdVuMat (float el, float az)
{
  vec2 ori, ca, sa;
  ori = vec2 (el, az);
  ca = cos (ori);
  sa = sin (ori);
  return mat3 (ca.y, 0., - sa.y, 0., 1., 0., sa.y, 0., ca.y) *
         mat3 (1., 0., 0., 0., ca.x, - sa.x, 0., sa.x, ca.x);
}

vec2 Rot2D (vec2 q, float a)
{
  vec2 cs;
  cs = sin (a + vec2 (0.5 * pi, 0.));
  return vec2 (dot (q, vec2 (cs.x, - cs.y)), dot (q.yx, cs));
}

vec2 Rot2Cs (vec2 q, vec2 cs)
{
  return vec2 (dot (q, vec2 (cs.x, - cs.y)), dot (q.yx, cs));
}

float FontTexDf (vec2 p, float id)
{
  vec3 tx;
  float d;
  tx = texture2D (txFnt, fract ((vec2 (mod (id, 16.),
     15. - floor (id / 16.)) + fract (p)) * (1. / 16.))).gba - 0.5;
  qnTex = vec2 (tx.r, - tx.g);
  d = tx.b + 1. / 256.;
  return d;
}

const float cHashM = 43758.54;

float Hashfv2 (vec2 p)
{
  return fract (sin (dot (p, vec2 (37., 39.))) * cHashM);
}

float Hashfv3 (vec3 p)
{
  return fract (sin (dot (p, vec3 (37., 39., 41.))) * cHashM);
}

vec3 Hashv3f (float p)
{
  return fract (sin (p + vec3 (37., 39., 41.)) * cHashM);
      
}


///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

